/*
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
define("ace/mode/luahtml",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/lua","ace/tokenizer","ace/mode/luahtml_highlight_rules"],function(b,c,a){var d=b("../lib/oop");
var h=b("./html").Mode;var e=b("./lua").Mode;var g=b("../tokenizer").Tokenizer;var f=b("./luahtml_highlight_rules").LuaHtmlHighlightRules;var i=function(){var j=new f();
this.$tokenizer=new g(new f().getRules());this.$embeds=j.getEmbeds();this.createModeDelegates({"lua-":e});};d.inherits(i,h);c.Mode=i;});define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/tokenizer","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html"],function(c,f,b){var h=c("../lib/oop");
var d=c("./text").Mode;var l=c("./javascript").Mode;var g=c("./css").Mode;var i=c("../tokenizer").Tokenizer;var e=c("./html_highlight_rules").HtmlHighlightRules;
var a=c("./behaviour/xml").XmlBehaviour;var j=c("./folding/html").FoldMode;var k=function(){var m=new e();this.$tokenizer=new i(m.getRules());this.$behaviour=new a();
this.$embeds=m.getEmbeds();this.createModeDelegates({"js-":l,"css-":g});this.foldingRules=new j();};h.inherits(k,d);(function(){this.toggleCommentLines=function(o,p,n,m){return 0;
};this.getNextLineIndent=function(o,m,n){return this.$getIndent(m);};this.checkOutdent=function(o,m,n){return false;};}).call(k.prototype);f.Mode=k;});
define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(d,f,b){var h=d("../lib/oop");
var e=d("./text").Mode;var i=d("../tokenizer").Tokenizer;var g=d("./javascript_highlight_rules").JavaScriptHighlightRules;var k=d("./matching_brace_outdent").MatchingBraceOutdent;
var c=d("../range").Range;var a=d("../worker/worker_client").WorkerClient;var l=d("./behaviour/cstyle").CstyleBehaviour;var m=d("./folding/cstyle").FoldMode;
var j=function(){this.$tokenizer=new i(new g().getRules());this.$outdent=new k();this.$behaviour=new l();this.foldingRules=new m();};h.inherits(j,e);(function(){this.toggleCommentLines=function(n,t,u,q){var s=true;
var v=/^(\s*)\/\//;for(var r=u;r<=q;r++){if(!v.test(t.getLine(r))){s=false;break;}}if(s){var o=new c(0,0,0,0);for(var r=u;r<=q;r++){var w=t.getLine(r);
var p=w.match(v);o.start.row=r;o.end.row=r;o.end.column=p[0].length;t.replace(o,p[1]);}}else{t.indentRows(u,q,"//");}};this.getNextLineIndent=function(t,p,r){var o=this.$getIndent(p);
var s=this.$tokenizer.getLineTokens(p,t);var u=s.tokens;var n=s.state;if(u.length&&u[u.length-1].type=="comment"){return o;}if(t=="start"||t=="regex_allowed"){var q=p.match(/^.*(?:\bcase\b.*\:|[\{\(\[])\s*$/);
if(q){o+=r;}}else{if(t=="doc-start"){if(n=="start"||t=="regex_allowed"){return"";}var q=p.match(/^\s*(\/?)\*/);if(q){if(q[1]){o+=" ";}o+="* ";}}}return o;
};this.checkOutdent=function(p,n,o){return this.$outdent.checkOutdent(n,o);};this.autoOutdent=function(n,o,p){this.$outdent.autoOutdent(o,p);};this.createWorker=function(n){var o=new a(["ace"],"worker-javascript.js","ace/mode/javascript_worker","JavaScriptWorker");
o.attachToDocument(n.getDocument());o.on("jslint",function(r){var s=[];for(var q=0;q<r.data.length;q++){var p=r.data[q];if(p){s.push({row:p.line-1,column:p.character-1,text:p.reason,type:"warning",lint:p});
}}n.setAnnotations(s);});o.on("narcissus",function(p){n.setAnnotations([p.data]);});o.on("terminate",function(){n.clearAnnotations();});return o;};}).call(j.prototype);
f.Mode=j;});define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/unicode","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(f,g,d){var i=f("../lib/oop");
var c=f("../lib/lang");var b=f("../unicode");var e=f("./doc_comment_highlight_rules").DocCommentHighlightRules;var a=f("./text_highlight_rules").TextHighlightRules;
var h=function(){var m=c.arrayToMap(("Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document").split("|"));
var n=c.arrayToMap(("break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|const|yield|import|get|set").split("|"));
var k="case|do|else|finally|in|instanceof|return|throw|try|typeof|yield";var l=c.arrayToMap(("__parent__|__count__|escape|unescape|with|__proto__").split("|"));
var q=c.arrayToMap(("const|let|var|function").split("|"));var o=c.arrayToMap(("null|Infinity|NaN|undefined").split("|"));var r=c.arrayToMap(("class|enum|extends|super|export|implements|private|public|interface|package|protected|static").split("|"));
var p="["+b.packages.L+"\\$_]["+b.packages.L+b.packages.Mn+b.packages.Mc+b.packages.Nd+b.packages.Pc+"\\$_]*\\b";var j="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]?|37[0-7]?|[4-7][0-7]?|.)";
this.$rules={start:[{token:"comment",regex:/\/\/.*$/},e.getStartRule("doc-start"),{token:"comment",merge:true,regex:/\/\*/,next:"comment"},{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0[xX][0-9a-fA-F]+\b/},{token:"constant.numeric",regex:/[+-]?\d+(?:(?:\.\d*)?(?:[eE][+-]?\d+)?)?\b/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+p+")(\\.)(prototype)(\\.)("+p+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator","text"],regex:"("+p+")(\\.)(prototype)(\\.)("+p+")(\\s*)(=)(\\s*)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+p+")(\\.)("+p+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+p+")(\\s*)(=)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+p+")(\\.)("+p+")(\\s*)(=)(\\s*)(function)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function)(\\s+)("+p+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+p+")(\\s*)(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function)(\\s*)(\\()",next:"function_arguments"},{token:"constant.language.boolean",regex:/(?:true|false)\b/},{token:"keyword",regex:"(?:"+k+")\\b",next:"regex_allowed"},{token:["punctuation.operator","support.function"],regex:/(\.)(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:opzzzz|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:["punctuation.operator","support.function.dom"],regex:/(\.)(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:["punctuation.operator","support.constant"],regex:/(\.)(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|timeEnd|assert)\b/},{token:function(s){if(m.hasOwnProperty(s)){return"variable.language";
}else{if(l.hasOwnProperty(s)){return"invalid.deprecated";}else{if(q.hasOwnProperty(s)){return"storage.type";}else{if(n.hasOwnProperty(s)){return"keyword";
}else{if(o.hasOwnProperty(s)){return"constant.language";}else{if(r.hasOwnProperty(s)){return"invalid.illegal";}else{if(s=="debugger"){return"invalid.deprecated";
}else{return"identifier";}}}}}}}},regex:p},{token:"keyword.operator",regex:/!|\$|%|&|\*|\-\-|\-|\+\+|\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\|\||\?\:|\*=|%=|\+=|\-=|&=|\^=|\b(?:in|instanceof|new|delete|typeof|void)/,next:"regex_allowed"},{token:"punctuation.operator",regex:/\?|\:|\,|\;|\./,next:"regex_allowed"},{token:"paren.lparen",regex:/[\[({]/,next:"regex_allowed"},{token:"paren.rparen",regex:/[\])}]/},{token:"keyword.operator",regex:/\/=?/,next:"regex_allowed"},{token:"comment",regex:/^#!.*$/},{token:"text",regex:/\s+/}],regex_allowed:[e.getStartRule("doc-start"),{token:"comment",merge:true,regex:"\\/\\*",next:"comment_regex_allowed"},{token:"comment",regex:"\\/\\/.*$"},{token:"string.regexp",regex:"\\/",next:"regex",merge:true},{token:"text",regex:"\\s+"},{token:"empty",regex:"",next:"start"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/\\w*",next:"start",merge:true},{token:"string.regexp",regex:"[^\\\\/\\[]+",merge:true},{token:"string.regexp.charachterclass",regex:"\\[",next:"regex_character_class",merge:true},{token:"empty",regex:"",next:"start"}],regex_character_class:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp.charachterclass",regex:"]",next:"regex",merge:true},{token:"string.regexp.charachterclass",regex:"[^\\\\\\]]+",merge:true},{token:"empty",regex:"",next:"start"}],function_arguments:[{token:"variable.parameter",regex:p,},{token:"punctuation.operator",regex:"[, ]+",merge:true},{token:"punctuation.operator",regex:"$",merge:true},{token:"empty",regex:"",next:"start"}],comment_regex_allowed:[{token:"comment",regex:".*?\\*\\/",merge:true,next:"regex_allowed"},{token:"comment",merge:true,regex:".+"}],comment:[{token:"comment",regex:".*?\\*\\/",merge:true,next:"start"},{token:"comment",merge:true,regex:".+"}],qqstring:[{token:"constant.language.escape",regex:j},{token:"string",regex:'[^"\\\\]+',merge:true},{token:"string",regex:"\\\\$",next:"qqstring",merge:true},{token:"string",regex:'"|$',next:"start",merge:true}],qstring:[{token:"constant.language.escape",regex:j},{token:"string",regex:"[^'\\\\]+",merge:true},{token:"string",regex:"\\\\$",next:"qstring",merge:true},{token:"string",regex:"'|$",next:"start",merge:true}]};
this.embedRules(e,"doc-",[e.getEndRule("start")]);};i.inherits(h,a);g.JavaScriptHighlightRules=h;});define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(c,b,e){var f=c("../lib/oop");
var a=c("./text_highlight_rules").TextHighlightRules;var d=function(){this.$rules={start:[{token:"comment.doc.tag",regex:"@[\\w\\d_]+"},{token:"comment.doc",merge:true,regex:"\\s+"},{token:"comment.doc",merge:true,regex:"TODO"},{token:"comment.doc",merge:true,regex:"[^@\\*]+"},{token:"comment.doc",merge:true,regex:"."}]};
};f.inherits(d,a);d.getStartRule=function(g){return{token:"comment.doc",merge:true,regex:"\\/\\*(?=\\*)",next:g};};d.getEndRule=function(g){return{token:"comment.doc",merge:true,regex:"\\*\\/",next:g};
};b.DocCommentHighlightRules=d;});define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(c,b,d){var e=c("../range").Range;
var a=function(){};(function(){this.checkOutdent=function(f,g){if(!/^\s+$/.test(f)){return false;}return/^\s*\}/.test(g);};this.autoOutdent=function(k,l){var g=k.getLine(l);
var h=g.match(/^(\s*\})/);if(!h){return 0;}var i=h[1].length;var j=k.findMatchingBracket({row:l,column:i});if(!j||j.row==l){return 0;}var f=this.$getIndent(k.getLine(j.row));
k.replace(new e(l,0,l,i-1),f);};this.$getIndent=function(f){var g=f.match(/^(\s+)/);if(g){return g[1];}return"";};}).call(a.prototype);b.MatchingBraceOutdent=a;
});define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour"],function(c,a,d){var e=c("../../lib/oop");var f=c("../behaviour").Behaviour;
var b=function(){this.add("braces","insertion",function(h,j,m,p,r){if(r=="{"){var q=m.getSelectionRange();var k=p.doc.getTextRange(q);if(k!==""){return{text:"{"+k+"}",selection:false};
}else{return{text:"{}",selection:[1,1]};}}else{if(r=="}"){var s=m.getCursorPosition();var t=p.doc.getLine(s.row);var n=t.substring(s.column,s.column+1);
if(n=="}"){var g=p.$findOpeningBracket("}",{column:s.column+1,row:s.row});if(g!==null){return{text:"",selection:[1,1]};}}}else{if(r=="\n"){var s=m.getCursorPosition();
var t=p.doc.getLine(s.row);var n=t.substring(s.column,s.column+1);if(n=="}"){var o=p.findMatchingBracket({row:s.row,column:s.column+1});if(!o){return null;
}var i=this.getNextLineIndent(h,t.substring(0,t.length-1),p.getTabString());var l=this.$getIndent(p.doc.getLine(o.row));return{text:"\n"+i+"\n"+l,selection:[1,i.length,1,i.length]};
}}}}});this.add("braces","deletion",function(l,k,j,m,h){var i=m.doc.getTextRange(h);if(!h.isMultiLine()&&i=="{"){var g=m.doc.getLine(h.start.row);var n=g.substring(h.end.column,h.end.column+1);
if(n=="}"){h.end.column++;return h;}}});this.add("parens","insertion",function(h,i,k,m,o){if(o=="("){var n=k.getSelectionRange();var j=m.doc.getTextRange(n);
if(j!==""){return{text:"("+j+")",selection:false};}else{return{text:"()",selection:[1,1]};}}else{if(o==")"){var p=k.getCursorPosition();var q=m.doc.getLine(p.row);
var l=q.substring(p.column,p.column+1);if(l==")"){var g=m.$findOpeningBracket(")",{column:p.column+1,row:p.row});if(g!==null){return{text:"",selection:[1,1]};
}}}}});this.add("parens","deletion",function(l,k,j,m,h){var i=m.doc.getTextRange(h);if(!h.isMultiLine()&&i=="("){var g=m.doc.getLine(h.start.row);var n=g.substring(h.start.column+1,h.start.column+2);
if(n==")"){h.end.column++;return h;}}});this.add("string_dquotes","insertion",function(h,k,n,q,u){if(u=='"'||u=="'"){var g=u;var s=n.getSelectionRange();
var l=q.doc.getTextRange(s);if(l!==""){return{text:g+l+g,selection:false};}else{var t=n.getCursorPosition();var w=q.doc.getLine(t.row);var v=w.substring(t.column-1,t.column);
if(v=="\\"){return null;}var p=q.getTokens(s.start.row);var i=0,j;var m=-1;for(var r=0;r<p.length;r++){j=p[r];if(j.type=="string"){m=-1;}else{if(m<0){m=j.value.indexOf(g);
}}if((j.value.length+i)>s.start.column){break;}i+=p[r].value.length;}if(!j||(m<0&&j.type!=="comment"&&(j.type!=="string"||((s.start.column!==j.value.length+i-1)&&j.value.lastIndexOf(g)===j.value.length-1)))){return{text:g+g,selection:[1,1]};
}else{if(j&&j.type==="string"){var o=w.substring(t.column,t.column+1);if(o==g){return{text:"",selection:[1,1]};}}}}}});this.add("string_dquotes","deletion",function(l,k,j,m,h){var i=m.doc.getTextRange(h);
if(!h.isMultiLine()&&(i=='"'||i=="'")){var g=m.doc.getLine(h.start.row);var n=g.substring(h.start.column+1,h.start.column+2);if(n=='"'){h.end.column++;
return h;}}});};e.inherits(b,f);a.CstyleBehaviour=b;});define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(b,a,c){var d=b("../../lib/oop");
var f=b("../../range").Range;var g=b("./fold_mode").FoldMode;var e=a.FoldMode=function(){};d.inherits(e,g);(function(){this.foldingStartMarker=/(\{|\[)[^\}\]]*$|^\s*(\/\*)/;
this.foldingStopMarker=/^[^\[\{]*(\}|\])|^[\s\*]*(\*\/)/;this.getFoldWidgetRange=function(o,k,p){var q=o.getLine(p);var m=q.match(this.foldingStartMarker);
if(m){var l=m.index;if(m[1]){return this.openingBracketBlock(o,m[1],p,l);}var n=o.getCommentFoldRange(p,l+m[0].length);n.end.column-=2;return n;}if(k!=="markbeginend"){return;
}var m=q.match(this.foldingStopMarker);if(m){var l=m.index+m[0].length;if(m[2]){var n=o.getCommentFoldRange(p,l);n.end.column-=2;return n;}var j={row:p,column:l};
var h=o.$findOpeningBracket(m[1],j);if(!h){return;}h.column++;j.column--;return f.fromPoints(h,j);}};}).call(e.prototype);});define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(b,a,c){var e=b("../../range").Range;
var d=a.FoldMode=function(){};(function(){this.foldingStartMarker=null;this.foldingStopMarker=null;this.getFoldWidget=function(h,g,i){var f=h.getLine(i);
if(this.foldingStartMarker.test(f)){return"start";}if(g=="markbeginend"&&this.foldingStopMarker&&this.foldingStopMarker.test(f)){return"end";}return"";
};this.getFoldWidgetRange=function(g,f,h){return null;};this.indentationBlock=function(l,p,g){var o=/^\s*/;var n=p;var j=p;var q=l.getLine(p);var h=g||q.length;
var i=q.match(o)[0].length;var m=l.getLength();while(++p<m){q=l.getLine(p);var f=q.match(o)[0].length;if(f==q.length){continue;}if(f<=i){break;}j=p;}if(j>n){var k=l.getLine(j).length;
return new e(n,h,j,k);}};this.openingBracketBlock=function(k,f,n,h,m,l){var g={row:n,column:h+1};var j=k.$findClosingBracket(f,g,m,l);if(!j){return;}var i=k.foldWidgets[j.row];
if(i==null){i=this.getFoldWidget(k,j.row);}if(i=="start"){j.row--;j.column=k.getLine(j.row).length;}return e.fromPoints(g,j);};}).call(d.prototype);});
define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/folding/cstyle"],function(c,e,b){var g=c("../lib/oop");
var d=c("./text").Mode;var h=c("../tokenizer").Tokenizer;var f=c("./css_highlight_rules").CssHighlightRules;var j=c("./matching_brace_outdent").MatchingBraceOutdent;
var a=c("../worker/worker_client").WorkerClient;var k=c("./folding/cstyle").FoldMode;var i=function(){this.$tokenizer=new h(new f().getRules(),"i");this.$outdent=new j();
this.foldingRules=new k();};g.inherits(i,d);(function(){this.foldingRules="cStyle";this.getNextLineIndent=function(p,m,o){var l=this.$getIndent(m);var q=this.$tokenizer.getLineTokens(m,p).tokens;
if(q.length&&q[q.length-1].type=="comment"){return l;}var n=m.match(/^.*\{\s*$/);if(n){l+=o;}return l;};this.checkOutdent=function(n,l,m){return this.$outdent.checkOutdent(l,m);
};this.autoOutdent=function(l,m,n){this.$outdent.autoOutdent(m,n);};this.createWorker=function(l){var m=new a(["ace"],"worker-css.js","ace/mode/css_worker","Worker");
m.attachToDocument(l.getDocument());m.on("csslint",function(n){var o=[];n.data.forEach(function(p){o.push({row:p.line-1,column:p.col-1,text:p.message,type:p.type,lint:p});
});l.setAnnotations(o);});return m;};}).call(i.prototype);e.Mode=i;});define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(d,b,e){var f=d("../lib/oop");
var g=d("../lib/lang");var a=d("./text_highlight_rules").TextHighlightRules;var c=function(){var p=g.arrayToMap(("animation-fill-mode|alignment-adjust|alignment-baseline|animation-delay|animation-direction|animation-duration|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|animation|appearance|azimuth|backface-visibility|background-attachment|background-break|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|background|baseline-shift|binding|bleed|bookmark-label|bookmark-level|bookmark-state|bookmark-target|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|border|bottom|box-align|box-decoration-break|box-direction|box-flex-group|box-flex|box-lines|box-ordinal-group|box-orient|box-pack|box-shadow|box-sizing|break-after|break-before|break-inside|caption-side|clear|clip|color-profile|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|crop|cue-after|cue-before|cue|cursor|direction|display|dominant-baseline|drop-initial-after-adjust|drop-initial-after-align|drop-initial-before-adjust|drop-initial-before-align|drop-initial-size|drop-initial-value|elevation|empty-cells|fit|fit-position|float-offset|float|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|font|grid-columns|grid-rows|hanging-punctuation|height|hyphenate-after|hyphenate-before|hyphenate-character|hyphenate-lines|hyphenate-resource|hyphens|icon|image-orientation|image-rendering|image-resolution|inline-box-align|left|letter-spacing|line-height|line-stacking-ruby|line-stacking-shift|line-stacking-strategy|line-stacking|list-style-image|list-style-position|list-style-type|list-style|margin-bottom|margin-left|margin-right|margin-top|margin|mark-after|mark-before|mark|marks|marquee-direction|marquee-play-count|marquee-speed|marquee-style|max-height|max-width|min-height|min-width|move-to|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|orphans|outline-color|outline-offset|outline-style|outline-width|outline|overflow-style|overflow-x|overflow-y|overflow|padding-bottom|padding-left|padding-right|padding-top|padding|page-break-after|page-break-before|page-break-inside|page-policy|page|pause-after|pause-before|pause|perspective-origin|perspective|phonemes|pitch-range|pitch|play-during|position|presentation-level|punctuation-trim|quotes|rendering-intent|resize|rest-after|rest-before|rest|richness|right|rotation-point|rotation|ruby-align|ruby-overhang|ruby-position|ruby-span|size|speak-header|speak-numeral|speak-punctuation|speak|speech-rate|stress|string-set|table-layout|target-name|target-new|target-position|target|text-align-last|text-align|text-decoration|text-emphasis|text-height|text-indent|text-justify|text-outline|text-shadow|text-transform|text-wrap|top|transform-origin|transform-style|transform|transition-delay|transition-duration|transition-property|transition-timing-function|transition|unicode-bidi|vertical-align|visibility|voice-balance|voice-duration|voice-family|voice-pitch-range|voice-pitch|voice-rate|voice-stress|voice-volume|volume|white-space-collapse|white-space|widows|width|word-break|word-spacing|word-wrap|z-index").split("|"));
var l=g.arrayToMap(("rgb|rgba|url|attr|counter|counters").split("|"));var v=g.arrayToMap(("absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|fill|fixed|font-size|font|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|top|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero").split("|"));
var h=g.arrayToMap(("aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow").split("|"));var s=g.arrayToMap(("arial|century|comic|courier|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace").split("|"));
var r="\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";var n="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";var j="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";
var i=[{token:"comment",merge:true,regex:"\\/\\*",next:"ruleset_comment"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:["constant.numeric","keyword"],regex:"("+r+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"},{token:["constant.numeric"],regex:"([0-9]+)"},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:n},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:j},{token:function(w){if(p.hasOwnProperty(w.toLowerCase())){return"support.type";
}else{if(l.hasOwnProperty(w.toLowerCase())){return"support.function";}else{if(v.hasOwnProperty(w.toLowerCase())){return"support.constant";}else{if(h.hasOwnProperty(w.toLowerCase())){return"support.constant.color";
}else{if(s.hasOwnProperty(w.toLowerCase())){return"support.constant.fonts";}else{return"text";}}}}}},regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"}];var t=g.copyArray(i);
t.unshift({token:"paren.rparen",regex:"\\}",next:"start"});var m=g.copyArray(i);m.unshift({token:"paren.rparen",regex:"\\}",next:"media"});var q=[{token:"comment",merge:true,regex:".+"}];
var o=g.copyArray(q);o.unshift({token:"comment",regex:".*?\\*\\/",next:"start"});var u=g.copyArray(q);u.unshift({token:"comment",regex:".*?\\*\\/",next:"media"});
var k=g.copyArray(q);k.unshift({token:"comment",regex:".*?\\*\\/",next:"ruleset"});this.$rules={start:[{token:"comment",merge:true,regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"string",regex:"@.*?{",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"}],media:[{token:"comment",merge:true,regex:"\\/\\*",next:"media_comment"},{token:"paren.lparen",regex:"\\{",next:"media_ruleset"},{token:"string",regex:"\\}",next:"start"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant",regex:"[a-z0-9-_]+"}],comment:o,ruleset:t,ruleset_comment:k,media_ruleset:m,media_comment:u};
};f.inherits(c,a);b.CssHighlightRules=c;});define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_util","ace/mode/text_highlight_rules"],function(d,f,c){var i=d("../lib/oop");
var g=d("./css_highlight_rules").CssHighlightRules;var h=d("./javascript_highlight_rules").JavaScriptHighlightRules;var a=d("./xml_util");var b=d("./text_highlight_rules").TextHighlightRules;
var e=function(){this.$rules={start:[{token:"text",merge:true,regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:"xml_pe",regex:"<\\?.*?\\?>"},{token:"comment",merge:true,regex:"<\\!--",next:"comment"},{token:"xml_pe",regex:"<\\!.*?>"},{token:"meta.tag",regex:"<(?=s*script\\b)",next:"script"},{token:"meta.tag",regex:"<(?=s*style\\b)",next:"style"},{token:"meta.tag",regex:"<\\/?",next:"tag"},{token:"text",regex:"\\s+"},{token:"constant.character.entity",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"},{token:"text",regex:"[^<]+"}],cdata:[{token:"text",regex:"\\]\\]>",next:"start"},{token:"text",merge:true,regex:"\\s+"},{token:"text",merge:true,regex:".+"}],comment:[{token:"comment",regex:".*?-->",next:"start"},{token:"comment",merge:true,regex:".+"}]};
a.tag(this.$rules,"tag","start");a.tag(this.$rules,"style","css-start");a.tag(this.$rules,"script","js-start");this.embedRules(h,"js-",[{token:"comment",regex:"\\/\\/.*(?=<\\/script>)",next:"tag"},{token:"meta.tag",regex:"<\\/(?=script)",next:"tag"}]);
this.embedRules(g,"css-",[{token:"meta.tag",regex:"<\\/(?=style)",next:"tag"}]);};i.inherits(e,b);f.HtmlHighlightRules=e;});define("ace/mode/xml_util",["require","exports","module","ace/lib/lang"],function(e,c,g){var h=e("../lib/lang");
var f=h.arrayToMap(("button|form|input|label|select|textarea").split("|"));var b=h.arrayToMap(("table|tbody|td|tfoot|th|tr").split("|"));function d(i){return[{token:"string",regex:'".*?"'},{token:"string",merge:true,regex:'["].*',next:i+"_qqstring"},{token:"string",regex:"'.*?'"},{token:"string",merge:true,regex:"['].*",next:i+"_qstring"}];
}function a(i,j){return[{token:"string",merge:true,regex:".*?"+i,next:j},{token:"string",merge:true,regex:".+"}];}c.tag=function(i,j,k){i[j]=[{token:"text",regex:"\\s+"},{token:function(l){if(l==="a"){return"meta.tag.anchor";
}else{if(l==="img"){return"meta.tag.image";}else{if(l==="script"){return"meta.tag.script";}else{if(l==="style"){return"meta.tag.style";}else{if(f.hasOwnProperty(l.toLowerCase())){return"meta.tag.form";
}else{if(b.hasOwnProperty(l.toLowerCase())){return"meta.tag.table";}else{return"meta.tag";}}}}}}},merge:true,regex:"[-_a-zA-Z0-9:]+",next:j+"_embed_attribute_list"},{token:"empty",regex:"",next:j+"_embed_attribute_list"}];
i[j+"_qstring"]=a("'",j+"_embed_attribute_list");i[j+"_qqstring"]=a('"',j+"_embed_attribute_list");i[j+"_embed_attribute_list"]=[{token:"meta.tag",merge:true,regex:"/?>",next:k},{token:"keyword.operator",regex:"="},{token:"entity.other.attribute-name",regex:"[-_a-zA-Z0-9:]+"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"text",regex:"\\s+"}].concat(d(j));
};});define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle"],function(c,a,d){var f=c("../../lib/oop");
var g=c("../behaviour").Behaviour;var b=c("./cstyle").CstyleBehaviour;var e=function(){this.inherit(b,["string_dquotes"]);this.add("brackets","insertion",function(h,k,n,p,r){if(r=="<"){var q=n.getSelectionRange();
var l=p.doc.getTextRange(q);if(l!==""){return false;}else{return{text:"<>",selection:[1,1]};}}else{if(r==">"){var s=n.getCursorPosition();var t=p.doc.getLine(s.row);
var o=t.substring(s.column,s.column+1);if(o==">"){return{text:"",selection:[1,1]};}}else{if(r=="\n"){var s=n.getCursorPosition();var t=p.doc.getLine(s.row);
var j=t.substring(s.column,s.column+2);if(j=="</"){var i=this.$getIndent(p.doc.getLine(s.row))+p.getTabString();var m=this.$getIndent(p.doc.getLine(s.row));
return{text:"\n"+i+"\n"+m,selection:[1,i.length,1,i.length]};}}}}});};f.inherits(e,g);a.XmlBehaviour=e;});define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(c,b,d){var f=c("../../lib/oop");
var h=c("./mixed").FoldMode;var e=c("./xml").FoldMode;var a=c("./cstyle").FoldMode;var g=b.FoldMode=function(){h.call(this,new e({area:1,base:1,br:1,col:1,command:1,embed:1,hr:1,img:1,input:1,keygen:1,link:1,meta:1,param:1,source:1,track:1,wbr:1,li:1,dt:1,dd:1,p:1,rt:1,rp:1,optgroup:1,option:1,colgroup:1,td:1,th:1}),{"js-":new a(),"css-":new a()});
};f.inherits(g,h);});define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(b,a,c){var d=b("../../lib/oop");
var f=b("./fold_mode").FoldMode;var e=a.FoldMode=function(g,h){this.defaultMode=g;this.subModes=h;};d.inherits(e,f);(function(){this.$getMode=function(h){for(var g in this.subModes){if(h.indexOf(g)===0){return this.subModes[g];
}}return null;};this.$tryMode=function(g,i,h,k){var j=this.$getMode(g);return(j?j.getFoldWidget(i,h,k):"");};this.getFoldWidget=function(h,g,i){return(this.$tryMode(h.getState(i-1),h,g,i)||this.$tryMode(h.getState(i),h,g,i)||this.defaultMode.getFoldWidget(h,g,i));
};this.getFoldWidgetRange=function(h,g,j){var i=this.$getMode(h.getState(j-1));if(!i||!i.getFoldWidget(h,g,j)){i=this.$getMode(h.getState(j));}if(!i||!i.getFoldWidget(h,g,j)){i=this.defaultMode;
}return i.getFoldWidgetRange(h,g,j);};}).call(e.prototype);});define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/range","ace/mode/folding/fold_mode","ace/token_iterator"],function(e,f,c){var g=e("../../lib/oop");
var b=e("../../lib/lang");var d=e("../../range").Range;var i=e("./fold_mode").FoldMode;var h=e("../../token_iterator").TokenIterator;var a=f.FoldMode=function(j){i.call(this);
this.voidElements=j||{};};g.inherits(a,i);(function(){this.getFoldWidget=function(l,k,m){var j=this._getFirstTagInLine(l,m);if(j.closing){return k=="markbeginend"?"end":"";
}if(!j.tagName||this.voidElements[j.tagName.toLowerCase()]){return"";}if(j.selfClosing){return"";}if(j.value.indexOf("/"+j.tagName)!==-1){return"";}return"start";
};this._getFirstTagInLine=function(n,o){var m=n.getTokens(o);var l="";for(var k=0;k<m.length;k++){var j=m[k];if(j.type.indexOf("meta.tag")===0){l+=j.value;
}else{l+=b.stringRepeat(" ",j.value.length);}}return this._parseTag(l);};this.tagRe=/^(\s*)(<?(\/?)([-_a-zA-Z0-9:!]*)\s*(\/?)>?)/;this._parseTag=function(j){var k=this.tagRe.exec(j);
var l=this.tagRe.lastIndex||0;this.tagRe.lastIndex=0;return{value:j,match:k?k[2]:"",closing:k?!!k[3]:false,selfClosing:k?!!k[5]||k[2]=="/>":false,tagName:k?k[4]:"",column:k[1]?l+k[1].length:l};
};this._readTagForward=function(l){var k=l.getCurrentToken();if(!k){return null;}var m="";var n;do{if(k.type.indexOf("meta.tag")===0){if(!n){var n={row:l.getCurrentTokenRow(),column:l.getCurrentTokenColumn()};
}m+=k.value;if(m.indexOf(">")!==-1){var j=this._parseTag(m);j.start=n;j.end={row:l.getCurrentTokenRow(),column:l.getCurrentTokenColumn()+k.value.length};
l.stepForward();return j;}}}while(k=l.stepForward());return null;};this._readTagBackward=function(m){var l=m.getCurrentToken();if(!l){return null;}var n="";
var k;do{if(l.type.indexOf("meta.tag")===0){if(!k){k={row:m.getCurrentTokenRow(),column:m.getCurrentTokenColumn()+l.value.length};}n=l.value+n;if(n.indexOf("<")!==-1){var j=this._parseTag(n);
j.end=k;j.start={row:m.getCurrentTokenRow(),column:m.getCurrentTokenColumn()};m.stepBackward();return j;}}}while(l=m.stepBackward());return null;};this._pop=function(k,j){while(k.length){var l=k[k.length-1];
if(!j||l.tagName==j.tagName){return k.pop();}else{if(this.voidElements[j.tagName]){return;}else{if(this.voidElements[l.tagName]){k.pop();continue;}else{return null;
}}}}};this.getFoldWidgetRange=function(o,m,r){var l=this._getFirstTagInLine(o,r);if(!l.match){return null;}var p=l.closing||l.selfClosing;var q=[];var s;
if(!p){var n=new h(o,r,l.column);var j={row:r,column:l.column+l.tagName.length+2};while(s=this._readTagForward(n)){if(s.selfClosing){if(!q.length){s.start.column+=s.tagName.length+2;
s.end.column-=2;return d.fromPoints(s.start,s.end);}else{continue;}}if(s.closing){this._pop(q,s);if(q.length==0){return d.fromPoints(j,s.start);}}else{q.push(s);
}}}else{var n=new h(o,r,l.column+l.match.length);var k={row:r,column:l.column};while(s=this._readTagBackward(n)){if(s.selfClosing){if(!q.length){s.start.column+=s.tagName.length+2;
s.end.column-=2;return d.fromPoints(s.start,s.end);}else{continue;}}if(!s.closing){this._pop(q,s);if(q.length==0){s.start.column+=s.tagName.length+2;return d.fromPoints(s.start,k);
}}else{q.push(s);}}}};}).call(a.prototype);});define("ace/mode/lua",["require","exports","module","ace/lib/oop","ace/mode/text","ace/tokenizer","ace/mode/lua_highlight_rules"],function(d,b,f){var h=d("../lib/oop");
var a=d("./text").Mode;var c=d("../tokenizer").Tokenizer;var e=d("./lua_highlight_rules").LuaHighlightRules;var g=function(){this.$tokenizer=new c(new e().getRules());
};h.inherits(g,a);(function(){this.getNextLineIndent=function(j,t,k){var l=this.$getIndent(t);var r=this.$tokenizer.getLineTokens(t,j);var s=r.tokens;var q=["function","then","do","repeat"];
if(j=="start"){var p=t.match(/^.*[\{\(\[]\s*$/);if(p){l+=k;}else{for(var o in s){var m=s[o];if(m.type!="keyword"){continue;}var n=q.indexOf(m.value);if(n!=-1){l+=k;
break;}}}}return l;};}).call(g.prototype);b.Mode=g;});define("ace/mode/lua_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(c,b,e){var f=c("../lib/oop");
var g=c("../lib/lang");var a=c("./text_highlight_rules").TextHighlightRules;var d=function(){var n=g.arrayToMap(("break|do|else|elseif|end|for|function|if|in|local|repeat|return|then|until|while|or|and|not").split("|"));
var q=g.arrayToMap(("true|false|nil|_G|_VERSION").split("|"));var l=g.arrayToMap(("string|xpcall|package|tostring|print|os|unpack|require|getfenv|setmetatable|next|assert|tonumber|io|rawequal|collectgarbage|getmetatable|module|rawset|math|debug|pcall|table|newproxy|type|coroutine|_G|select|gcinfo|pairs|rawget|loadstring|ipairs|_VERSION|dofile|setfenv|load|error|loadfile|sub|upper|len|gfind|rep|find|match|char|dump|gmatch|reverse|byte|format|gsub|lower|preload|loadlib|loaded|loaders|cpath|config|path|seeall|exit|setlocale|date|getenv|difftime|remove|time|clock|tmpname|rename|execute|lines|write|close|flush|open|output|type|read|stderr|stdin|input|stdout|popen|tmpfile|log|max|acos|huge|ldexp|pi|cos|tanh|pow|deg|tan|cosh|sinh|random|randomseed|frexp|ceil|floor|rad|abs|sqrt|modf|asin|min|mod|fmod|log10|atan2|exp|sin|atan|getupvalue|debug|sethook|getmetatable|gethook|setmetatable|setlocal|traceback|setfenv|getinfo|setupvalue|getlocal|getregistry|getfenv|setn|insert|getn|foreachi|maxn|foreach|concat|sort|remove|resume|yield|status|wrap|create|running").split("|"));
var r=g.arrayToMap(("string|package|os|io|math|debug|table|coroutine").split("|"));var k=g.arrayToMap(("__add|__sub|__mod|__unm|__concat|__lt|__index|__call|__gc|__metatable|__mul|__div|__pow|__len|__eq|__le|__newindex|__tostring|__mode|__tonumber").split("|"));
var w=g.arrayToMap(("").split("|"));var u=g.arrayToMap(("setn|foreach|foreachi|gcinfo|log10|maxn").split("|"));var s="";var p="(?:(?:[1-9]\\d*)|(?:0))";
var j="(?:0[xX][\\dA-Fa-f]+)";var m="(?:"+p+"|"+j+")";var v="(?:\\.\\d+)";var h="(?:\\d+)";var o="(?:(?:"+h+"?"+v+")|(?:"+h+"\\.))";var t="(?:"+o+")";var i=[];
this.$rules={start:[{token:"comment",regex:s+"\\-\\-\\[\\[.*\\]\\]"},{token:"comment",regex:s+"\\-\\-\\[\\=\\[.*\\]\\=\\]"},{token:"comment",regex:s+"\\-\\-\\[\\={2}\\[.*\\]\\={2}\\]"},{token:"comment",regex:s+"\\-\\-\\[\\={3}\\[.*\\]\\={3}\\]"},{token:"comment",regex:s+"\\-\\-\\[\\={4}\\[.*\\]\\={4}\\]"},{token:"comment",regex:s+"\\-\\-\\[\\={5}\\=*\\[.*\\]\\={5}\\=*\\]"},{token:"comment",regex:s+"\\-\\-\\[\\[.*$",merge:true,next:"qcomment"},{token:"comment",regex:s+"\\-\\-\\[\\=\\[.*$",merge:true,next:"qcomment1"},{token:"comment",regex:s+"\\-\\-\\[\\={2}\\[.*$",merge:true,next:"qcomment2"},{token:"comment",regex:s+"\\-\\-\\[\\={3}\\[.*$",merge:true,next:"qcomment3"},{token:"comment",regex:s+"\\-\\-\\[\\={4}\\[.*$",merge:true,next:"qcomment4"},{token:function(z){var y=/\-\-\[(\=+)\[/,x;
if((x=y.exec(z))!=null&&(x=x[1])!=undefined){i.push(x.length);}return"comment";},regex:s+"\\-\\-\\[\\={5}\\=*\\[.*$",merge:true,next:"qcomment5"},{token:"comment",regex:"\\-\\-.*$"},{token:"string",regex:s+"\\[\\[.*\\]\\]"},{token:"string",regex:s+"\\[\\=\\[.*\\]\\=\\]"},{token:"string",regex:s+"\\[\\={2}\\[.*\\]\\={2}\\]"},{token:"string",regex:s+"\\[\\={3}\\[.*\\]\\={3}\\]"},{token:"string",regex:s+"\\[\\={4}\\[.*\\]\\={4}\\]"},{token:"string",regex:s+"\\[\\={5}\\=*\\[.*\\]\\={5}\\=*\\]"},{token:"string",regex:s+"\\[\\[.*$",merge:true,next:"qstring"},{token:"string",regex:s+"\\[\\=\\[.*$",merge:true,next:"qstring1"},{token:"string",regex:s+"\\[\\={2}\\[.*$",merge:true,next:"qstring2"},{token:"string",regex:s+"\\[\\={3}\\[.*$",merge:true,next:"qstring3"},{token:"string",regex:s+"\\[\\={4}\\[.*$",merge:true,next:"qstring4"},{token:function(z){var y=/\[(\=+)\[/,x;
if((x=y.exec(z))!=null&&(x=x[1])!=undefined){i.push(x.length);}return"string";},regex:s+"\\[\\={5}\\=*\\[.*$",merge:true,next:"qstring5"},{token:"string",regex:s+'"(?:[^\\\\]|\\\\.)*?"'},{token:"string",regex:s+"'(?:[^\\\\]|\\\\.)*?'"},{token:"constant.numeric",regex:t},{token:"constant.numeric",regex:m+"\\b"},{token:function(x){if(n.hasOwnProperty(x)){return"keyword";
}else{if(q.hasOwnProperty(x)){return"constant.language";}else{if(w.hasOwnProperty(x)){return"invalid.illegal";}else{if(r.hasOwnProperty(x)){return"constant.library";
}else{if(u.hasOwnProperty(x)){return"invalid.deprecated";}else{if(l.hasOwnProperty(x)){return"support.function";}else{if(k.hasOwnProperty(x)){return"support.function";
}else{return"identifier";}}}}}}}},regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"keyword.operator",regex:"\\+|\\-|\\*|\\/|%|\\#|\\^|~|<|>|<=|=>|==|~=|=|\\:|\\.\\.\\.|\\.\\."},{token:"paren.lparen",regex:"[\\[\\(\\{]"},{token:"paren.rparen",regex:"[\\]\\)\\}]"},{token:"text",regex:"\\s+"}],qcomment:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment1:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\=\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment2:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={2}\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment3:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={3}\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment4:[{token:"comment",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={4}\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qcomment5:[{token:function(B){var A=/\](\=+)\]/,C=this.rules.qcomment5[0],x;
C.next="start";if((x=A.exec(B))!=null&&(x=x[1])!=undefined){var z=x.length,y;if((y=i.pop())!=z){i.push(y);C.next="qcomment5";}}return"comment";},regex:"(?:[^\\\\]|\\\\.)*?\\]\\={5}\\=*\\]",next:"start"},{token:"comment",merge:true,regex:".+"}],qstring:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring1:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\=\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring2:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={2}\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring3:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={3}\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring4:[{token:"string",regex:"(?:[^\\\\]|\\\\.)*?\\]\\={4}\\]",next:"start"},{token:"string",merge:true,regex:".+"}],qstring5:[{token:function(B){var A=/\](\=+)\]/,C=this.rules.qstring5[0],x;
C.next="start";if((x=A.exec(B))!=null&&(x=x[1])!=undefined){var z=x.length,y;if((y=i.pop())!=z){i.push(y);C.next="qstring5";}}return"string";},regex:"(?:[^\\\\]|\\\\.)*?\\]\\={5}\\=*\\]",next:"start"},{token:"string",merge:true,regex:".+"}]};
};f.inherits(d,a);b.LuaHighlightRules=d;});define("ace/mode/luahtml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/lua_highlight_rules"],function(b,a,d){var e=b("../lib/oop");
var g=b("./html_highlight_rules").HtmlHighlightRules;var c=b("./lua_highlight_rules").LuaHighlightRules;var f=function(){this.$rules=new g().getRules();
for(var h in this.$rules){this.$rules[h].unshift({token:"luatag-percent",regex:"<\\%",next:"lua-start"},{token:"luatag-lua",regex:"<\\?lua",next:"lua-start"});
}this.embedRules(c,"lua-",[{token:"keyword1",regex:"\\%>",next:"start"},{token:"keyword2",regex:"\\?>",next:"start"}]);};e.inherits(f,g);a.LuaHtmlHighlightRules=f;
});