<?php
/**
 * @version   $Id: ICache.php 10831 2013-05-29 19:32:17Z btowles $
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2015 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */

defined('ROKCOMMON') or die;

/**
 * @package    RokCommon
 * @subpackage Cache
 */
class RokCommon_Cache_Exception extends Exception
{
}

/**
 * @package    RokCommon
 * @subpackage Cache
 */
interface RokCommon_ICache
{

	/**
	 *
	 */
	const DEFAULT_LIFETIME = 900;

	/**
	 * Save data to cache
	 *
	 * @param string $groupName  Name of group of cache
	 * @param string $identifier Identifier of data - it should be unique in group
	 * @param mixed  $data       Data
	 *
	 * @internal param string $driver Driver strategy
	 *
	 * @throws RokCommon_Cache_Exception
	 * @return boolean
	 */
	public function set($groupName, $identifier, $data);

	/**
	 * Gets data from cache
	 *
	 * @param string $groupName  Name of group
	 * @param string $identifier Identifier of data
	 *
	 * @internal param string $driver Driver strategy
	 *
	 * @throws RokCommon_Cache_Exception
	 * @return mixed
	 */
	public function get($groupName, $identifier);


	/**
	 * Clears cache of specified identifier of group  with one/all drivers
	 *
	 * @abstract
	 *
	 * @param string $groupName  Name of group
	 * @param string $identifier Identifier
	 *
	 * @return boolean
	 */
	public function clearCache($groupName, $identifier);


	/**
	 * Clears all cache generated by this class with one/all drivers
	 *
	 * @internal param string $driver Name of driver strategy
	 *
	 * @return boolean
	 */
	public function clearAllCache();

	/**
	 * Sets the lifetime
	 *
	 * @abstract
	 *
	 * @param int    $lifetime  Lifetime of the cache
	 *
	 * @return boolean
	 */
	public function setLifeTime($lifetime);

	/**
	 * Clears cache of specified group  with one/all drivers
	 *
	 * @param string $groupName Name of group
	 *
	 * @return boolean
	 */
	public function clearGroupCache($groupName);

	/**
	 * Check if cache data exists
	 *
	 * @abstract
	 *
	 * @param string $groupName  Name of group
	 * @param string $identifier Identifier
	 *
	 * @return boolean
	 */
	public function exists($groupName, $identifier);

}